package w83b.w83bOperacionesPaso.w83bIncidencias;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import w83b.w83bBeans.W83bActasBean;
import w83b.w83bBeans.W83bDocBean;
import w83b.w83bBeans.W83bIncidenciasBean;
import w83b.w83bBeans.W83bNuevaIncidenciasBean;
import w83b.w83bUtilidadesComunes.W83bClsConstantes;
import es.ejie.frmk.presentacion.operacion.paso.Q70ActionPasoOP;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;

// TODO: Auto-generated Javadoc
/**
 * The Class W83bTablaAgrupacionesOP.java.
 *
 * @author Deusto Sistemas
 */
public class W83bIncidenciasIraActasOPAction extends Q70ActionPasoOP{

	
	protected void processOP(Q70ContextoEJIE contexto, ActionErrors errores, ActionMapping mapping,
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
		//Guardamos la accion en el contexto

		
	}

	protected ActionForward processForward(Q70ContextoEJIE contexto, ActionErrors errors, ActionMapping mapping, 
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
		
		W83bNuevaIncidenciasBean incidencia = (W83bNuevaIncidenciasBean)contexto.get("w83bNuevaIncidenciasBean");
				
		W83bActasBean acta = new W83bActasBean();
		
		if(!W83bClsConstantes.CONSTANTE_ACTA_PARCIAL.equals(incidencia.getTipologiaIncidencia())){
			acta.setNumActaAno(incidencia.getActaAnyo());
			acta.setNumActa(incidencia.getActaNumero());
		}else{
			acta.setNumActaAno(incidencia.getActaTotal().substring(0, 4));
			acta.setNumActa(incidencia.getActaTotal().substring(4));
		}
		acta.setNumActaTerritorio(incidencia.getActaTerritorio());
		acta.setVersion(incidencia.getActaVersion());
		
		
		List listaActas = new ArrayList();
		listaActas.add(acta);
		
		contexto.set("w83bListaActas",listaActas);	
		
		HashMap mapaActas = new HashMap();
		
		StringBuffer actaStr = new StringBuffer(W83bClsConstantes.UNO);
		actaStr.append(acta.getNumActaTerritorio());
		actaStr.append("/");
		actaStr.append(acta.getNumActaAno());
		actaStr.append("/");
		actaStr.append(acta.getNumActa());
		actaStr.append("/");
		actaStr.append("0");
		
		mapaActas.put("codSelec",actaStr.toString());
			
		contexto.set("w83bMapaActas",mapaActas);
		
		if (contexto.get("w83bMapaFileIncidencias")!=null)
		{

			HashMap mapaFiles =(HashMap)contexto.get("w83bMapaFileIncidencias");
			Iterator iter = mapaFiles.keySet().iterator();
			W83bDocBean docBean=null;
			while (iter.hasNext())
			{
				HashMap datosFile=(HashMap)mapaFiles.get(iter.next());
				docBean= new W83bDocBean();//NOPMD
				docBean.setCodFase(((String)datosFile.get("tipodocumento")).split("_")[1]);
				docBean.setCodTramite(((String)datosFile.get("tipodocumento")).split("_")[2]);
				docBean.setNombre((String)datosFile.get("nombreDocumento"));
				docBean.setTipoDocumento(((String)datosFile.get("tipodocumento")).split("_")[0]);
				docBean.setFechaRegistro((String)datosFile.get("fecharegistro"));
				docBean.setUsuario((String)datosFile.get("usuario"));
				docBean.setNumeroRegistro((String)datosFile.get("numregistro"));
				docBean.setFileData((InputStream)datosFile.get("documentoStream"));
				docBean.setTamanyo(((Long)datosFile.get("tamanyo")).intValue());
				incidencia.getListaDocs().add(docBean);

			}
		}
		
		//PARA VOLVER DE ACTAS
		W83bIncidenciasBean beanBusq = new W83bIncidenciasBean();
		
		beanBusq.setTerritorioIncidencia(incidencia.getIncidenciaTerritorio());
		beanBusq.setAnyoIncidencia(incidencia.getIncidenciaAnyo());
		beanBusq.setNumIncidencia(incidencia.getIncidenciaNumero());
		
		List listaIncidencias = new ArrayList();
		listaIncidencias.add(beanBusq);
		contexto.set("w83bListaIncidencias",listaIncidencias);
		contexto.set("codSelec","0");
		//FIN PARA VOLVER DE ACTAS
		
		if(W83bClsConstantes.CONSTANTE_ACTA_PARCIAL.equals(incidencia.getTipologiaIncidencia())){
			incidencia.setActaParcial(incidencia.getActaAnyo()+incidencia.getActaNumero());
			incidencia.setActaAnyo(incidencia.getActaTotal().substring(0, 4));
			incidencia.setActaNumero(incidencia.getActaTotal().substring(4));
			contexto.set("w83bNuevaIncidenciasBean",incidencia);
		}
		
		return mapping.findForward("ok");
	}

}
